/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.custinfo;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardBaseTask;
import com.ibm.hsc.iw.WizardCommitStatus;
import com.ibm.hsc.iw.WizardFrame;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.WizardTaskPanel;
import com.ibm.hsc.iw.WizardTaskState;
import com.ibm.hsc.iw.tasks.custinfo.AdministratorBean1;
import com.ibm.hsc.iw.tasks.custinfo.AdministratorBean2;
import com.ibm.hsc.iw.tasks.custinfo.CustomerContactConstants;
import com.ibm.hsc.iw.tasks.custinfo.CustomerContactInit;
import com.ibm.hsc.iw.tasks.custinfo.CustomerContactState;
import com.ibm.hsc.iw.tasks.custinfo.SystemBean;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import java.io.Serializable;
import java.util.Locale;

public class CustomerContactTask
extends WizardBaseTask
implements CustomerContactConstants {
    private static final String TRACE_MASKD = "JIWZCCTD";
    private static final String TRACE_MASKF = "JIWZCCTF";
    private static final String TRACE_MASKT = "JIWZCCTT";
    private CustomerContactInit custContactInit;

    public CustomerContactTask() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->CustomerContactTask()");
        }
    }

    public static void main(String[] stringArray) {
        if (Trace.LEVEL >= 3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(stringArray[i]);
            }
            Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + stringBuffer.toString());
        }
    }

    public LocalizableText getDescription() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getDescription()");
        }
        return new LocalizableText("com.ibm.hsc.common.bundles.CustomerContactText", "TASK_DESCRIPTION");
    }

    public WizardTaskState init(WizardFrame wizardFrame) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->init(" + wizardFrame + ")");
        }
        CustomerInfoManager customerInfoManager = CustomerInfoManager.getCustomerInfoManager();
        Locale locale = UserContext.getCurrentUserContext().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "locale from UserContext is null, using JVM default");
            }
        }
        ConnectionInfoManager connectionInfoManager = ConnectionInfoManager.getConnectionInfoManager();
        this.custContactInit = new CustomerContactInit(new CustomerContactState(), locale, customerInfoManager.getCustomerInfo(), connectionInfoManager.getDisplayableCountries(locale), connectionInfoManager.getDisplayableSubdivisions(locale));
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, customerInfoManager.getCustomerInfo().toString());
        }
        return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.custinfo.res.CustomerContact", "customer_contact1", "com.ibm.hsc.iw.tasks.custinfo.AdministratorBean1", new LocalizableText("com.ibm.hsc.common.bundles.CustomerContactText", "TITLE_BAR_EXT")), this.custContactInit);
    }

    public void exit() {
    }

    public WizardTaskState nextButtonHit(Serializable serializable) throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->nextButtonHit()");
        }
        CustomerContactState customerContactState = (CustomerContactState)serializable;
        this.custContactInit.setCustomerContactState(customerContactState);
        if (customerContactState.getActivePanelName().equals("customer_contact1")) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 1");
            }
            this.saveAdminBean1(this.custContactInit);
            customerContactState.setActivePanelName("customer_contact2");
            return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.custinfo.res.CustomerContact", "customer_contact2", "com.ibm.hsc.iw.tasks.custinfo.AdministratorBean2", new LocalizableText("com.ibm.hsc.common.bundles.CustomerContactText", "TITLE_BAR_EXT")), this.custContactInit);
        }
        if (customerContactState.getActivePanelName().equals("customer_contact2")) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 2");
            }
            this.saveAdminBean2(this.custContactInit);
            customerContactState.setActivePanelName("customer_contact3");
            return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.custinfo.res.CustomerContact", "customer_contact3", "com.ibm.hsc.iw.tasks.custinfo.SystemBean", new LocalizableText("com.ibm.hsc.common.bundles.CustomerContactText", "TITLE_BAR_EXT")), this.custContactInit);
        }
        if (Trace.LEVEL >= 3) {
            Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 3");
        }
        this.saveSystemBean(this.custContactInit);
        customerContactState.setActivePanelName("");
        return new WizardTaskState(null, this.custContactInit);
    }

    public Object backButtonHit(Serializable serializable) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->backButtonHit()");
        }
        CustomerContactState customerContactState = (CustomerContactState)serializable;
        this.custContactInit.setCustomerContactState(customerContactState);
        if (customerContactState.getActivePanelName().equals("customer_contact1")) {
            this.saveAdminBean1(this.custContactInit);
        } else if (customerContactState.getActivePanelName().equals("customer_contact2")) {
            this.saveAdminBean2(this.custContactInit);
        } else if (customerContactState.getActivePanelName().equals("customer_contact3")) {
            this.saveSystemBean(this.custContactInit);
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "backButtonHit with Dummy panel. Should not happen.");
            }
            new AusMicrocodeLog(LOG_INFO_TASK, 3).writeEntry(null);
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--backButtonHit()");
        }
        return this.custContactInit;
    }

    public Object backedIntoPanel(WizardTaskState wizardTaskState) {
        CustomerContactState customerContactState;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->backedIntoPanel()");
        }
        if ((customerContactState = this.custContactInit.getCustomerContactState()).getActivePanelName().equals("customer_contact1")) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "backedIntoPanel with panel 1. Should not happen.");
            }
            new AusMicrocodeLog(LOG_INFO_TASK, 4).writeEntry(null);
        } else if (customerContactState.getActivePanelName().equals("customer_contact2")) {
            customerContactState.setActivePanelName("customer_contact1");
        } else if (customerContactState.getActivePanelName().equals("customer_contact3")) {
            customerContactState.setActivePanelName("customer_contact2");
        } else {
            customerContactState.setActivePanelName("customer_contact3");
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--backedIntoPanel()");
        }
        return this.custContactInit;
    }

    public LocalizableText[] prepareToCommit(Object object) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->prepareToCommit()");
        }
        CustomerContactInit customerContactInit = (CustomerContactInit)object;
        CustomerContactState customerContactState = customerContactInit.getCustomerContactState();
        LocalizableText[] localizableTextArray = new LocalizableText[]{new LocalizableText("com.ibm.hsc.common.bundles.CustomerContactText", "COMMIT_DESCRIPTION")};
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--prepareToCommit()");
        }
        return localizableTextArray;
    }

    public WizardCommitStatus commit(Object object) {
        CustomerContactInit customerContactInit = (CustomerContactInit)object;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->commit()");
        }
        CustomerContactState customerContactState = customerContactInit.getCustomerContactState();
        boolean bl = true;
        HSCLocalizableMsg[] hSCLocalizableMsgArray = null;
        Object[] objectArray = null;
        bl = this.setCustomerContactInfo();
        hSCLocalizableMsgArray = new HSCLocalizableMsg[]{bl ? new HSCLocalizableMsg(MsgType.INFORMATION_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0500", objectArray) : new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0501", objectArray)};
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--commit()");
        }
        return new WizardCommitStatus(bl, hSCLocalizableMsgArray);
    }

    public void saveAdminBean1(Object object) {
        CustomerContactInit customerContactInit = (CustomerContactInit)object;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->saveAdminBean1()");
        }
        CustomerContactState customerContactState = customerContactInit.getCustomerContactState();
        CustomerInfoData customerInfoData = customerContactInit.getCustomerInfoData();
        AdministratorBean1 administratorBean1 = customerContactState.getAdminBean1();
        customerInfoData.setAdminCompany(administratorBean1.getCompanyName());
        customerInfoData.setAdminName(administratorBean1.getAdministratorName());
        customerInfoData.setAdminEmail(administratorBean1.getEmailAddress());
        customerInfoData.setAdminPhone(administratorBean1.getPhoneNumber());
        customerInfoData.setAdminAltPhone(administratorBean1.getAlternatePhoneNumber());
        customerInfoData.setAdminFax(administratorBean1.getFaxNumber());
        customerInfoData.setAdminAltFax(administratorBean1.getAlternateFaxNumber());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--saveAdminBean1()");
        }
    }

    public void saveAdminBean2(Object object) {
        CustomerContactInit customerContactInit = (CustomerContactInit)object;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->saveAdminBean2()");
        }
        CustomerContactState customerContactState = customerContactInit.getCustomerContactState();
        CustomerInfoData customerInfoData = customerContactInit.getCustomerInfoData();
        AdministratorBean2 administratorBean2 = customerContactState.getAdminBean2();
        customerInfoData.setAdminStreetAddr(administratorBean2.getStreetAddress());
        customerInfoData.setAdminStreetAddr2(administratorBean2.getStreetAddress2());
        customerInfoData.setAdminCity(administratorBean2.getCityLocality());
        customerInfoData.setAdminCountryCode(administratorBean2.getCountryCode());
        customerInfoData.setAdminSubdivisionCode(administratorBean2.getSubdivisionCode());
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, " saveAdminBean2() CountryCode: " + administratorBean2.getCountryCode() + " SubdivisionCode: " + administratorBean2.getSubdivisionCode());
        }
        customerInfoData.setAdminPostalCode(administratorBean2.getPostalCode());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--saveAdminBean2()");
        }
    }

    public void saveSystemBean(Object object) {
        CustomerContactInit customerContactInit = (CustomerContactInit)object;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->saveSystemBean()");
        }
        CustomerContactState customerContactState = customerContactInit.getCustomerContactState();
        CustomerInfoData customerInfoData = customerContactInit.getCustomerInfoData();
        SystemBean systemBean = customerContactState.getSystemBean();
        customerInfoData.setSystemUseAdminAddr(systemBean.isUseAdminMailingAddress());
        if (!customerInfoData.isSystemUseAdminAddr()) {
            customerInfoData.setSystemStreetAddr(systemBean.getStreetAddress());
            customerInfoData.setSystemStreetAddr2(systemBean.getStreetAddress2());
            customerInfoData.setSystemCity(systemBean.getCityLocality());
            customerInfoData.setSystemCountryCode(systemBean.getCountryCode());
            customerInfoData.setSystemSubdivisionCode(systemBean.getSubdivisionCode());
            customerInfoData.setSystemPostalCode(systemBean.getPostalCode());
        }
        customerInfoData.setSystemModemNumber(systemBean.getModemNumber());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--saveSystemBean()");
        }
    }

    private boolean setCustomerContactInfo() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setCustomerContactInfo()");
        }
        CustomerInfoManager customerInfoManager = CustomerInfoManager.getCustomerInfoManager();
        CustomerInfoData customerInfoData = this.custContactInit.getCustomerInfoData();
        if (customerInfoData.isSystemUseAdminAddr()) {
            customerInfoData.setSystemStreetAddr(customerInfoData.getAdminStreetAddr());
            customerInfoData.setSystemStreetAddr2(customerInfoData.getAdminStreetAddr2());
            customerInfoData.setSystemCity(customerInfoData.getAdminCity());
            customerInfoData.setSystemCountryCode(customerInfoData.getAdminCountryCode());
            customerInfoData.setSystemSubdivisionCode(customerInfoData.getAdminSubdivisionCode());
            customerInfoData.setSystemPostalCode(customerInfoData.getAdminPostalCode());
        }
        customerInfoManager.setCustomerInfo(customerInfoData);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setCustomerContactInfo()");
        }
        return true;
    }
}

